<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'church_admin') { header('Location: ../index.php'); exit; }

$churchId     = $user['church_id'];
$church       = getChurchInfo($churchId);
$ministries   = getMinistries($churchId);
$membersData  = getMembers($churchId);
$activeMembers= array_filter($membersData['members'], fn($m) => $m['status'] === 'activo');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'save_type') {
        $tid  = $_POST['type_id'] ?: generateId('mnt');
        $name = trim($_POST['type_name'] ?? '');
        if (!$name) { flashMessage('danger','O nome do ministério é obrigatório.'); header('Location: ministries.php'); exit; }
        $found = false;
        foreach ($ministries['types'] as &$t) {
            if ($t['id'] === $tid) { $t['name'] = $name; $t['description'] = trim($_POST['type_desc'] ?? ''); $found = true; break; }
        }
        if (!$found) $ministries['types'][] = ['id'=>$tid,'name'=>$name,'description'=>trim($_POST['type_desc'] ?? ''),'created_at'=>date('Y-m-d H:i:s')];
        saveMinistries($churchId, $ministries);
        flashMessage('success','Ministério guardado com sucesso.');
        header('Location: ministries.php'); exit;
    }

    if ($action === 'assign') {
        $memberId   = $_POST['assign_member'] ?? '';
        $ministryId = $_POST['assign_ministry'] ?? '';
        $subId      = $_POST['assign_subdivision'] ?? '';
        $date       = $_POST['assign_date'] ?? date('Y-m-d');
        if (!$memberId || !$ministryId) { flashMessage('danger','Membro e ministério são obrigatórios.'); header('Location: ministries.php'); exit; }

        // Remover atribuição anterior do mesmo membro ao mesmo ministério
        $ministries['assignments'] = array_values(array_filter($ministries['assignments'], fn($a) => !($a['member_id']===$memberId && $a['ministry_id']===$ministryId)));
        $ministries['assignments'][] = [
            'id'          => generateId('asg'),
            'member_id'   => $memberId,
            'ministry_id' => $ministryId,
            'subdivision_id' => $subId ?: null,
            'date'        => $date,
            'assigned_at' => date('Y-m-d H:i:s')
        ];
        saveMinistries($churchId, $ministries);
        flashMessage('success','Membro vinculado ao ministério com sucesso.');
        header('Location: ministries.php'); exit;
    }

    if ($action === 'remove_assignment') {
        $aid = $_POST['assignment_id'] ?? '';
        $ministries['assignments'] = array_values(array_filter($ministries['assignments'], fn($a) => $a['id'] !== $aid));
        saveMinistries($churchId, $ministries);
        flashMessage('success','Vínculo removido.');
        header('Location: ministries.php'); exit;
    }

    if ($action === 'delete_type') {
        $tid = $_POST['type_id'] ?? '';
        $ministries['types'] = array_values(array_filter($ministries['types'], fn($t) => $t['id'] !== $tid));
        $ministries['assignments'] = array_values(array_filter($ministries['assignments'], fn($a) => $a['ministry_id'] !== $tid));
        saveMinistries($churchId, $ministries);
        flashMessage('success','Ministério e vínculos removidos.');
        header('Location: ministries.php'); exit;
    }
}

$subsData = getSubdivisions($churchId);

renderHead('Ministérios — ' . $church['name']);
?>
<body>
<?php renderSidebar($user['role']); ?>
<div class="main-content">
    <div class="topbar">
        <div style="display:flex;align-items:center;gap:.85rem"><button class="hamburger" onclick="toggleSidebar()"><span></span><span></span><span></span></button><div><div class="topbar-title">Ministérios & Consagração</div><div class="topbar-sub"><?= sanitize($church['name']) ?></div></div></div>
        <div class="topbar-actions">
            <button class="btn btn-outline btn-sm" data-modal="modal-type">＋ Criar Ministério</button>
            <button class="btn btn-primary btn-sm" data-modal="modal-assign">✝️ Vincular Membro</button>
        </div>
    </div>
    <div class="page-content">
        <?php renderSuggestionBanner(); ?>
        <?php renderFlash(); ?>

        <!-- Tipos de Ministério -->
        <div class="card" style="margin-bottom:1.5rem">
            <div class="card-header"><h3 class="card-title">Tipos de Ministério</h3><span class="badge badge-gold"><?= count($ministries['types']) ?></span></div>
            <?php if (empty($ministries['types'])): ?>
            <div class="empty-state"><div class="empty-icon">✝️</div><h3>Sem ministérios</h3><p>Crie os ministérios da sua denominação (Bispo, Pastor, Diácono, Evangelista...)</p><button class="btn btn-primary" data-modal="modal-type">Criar Primeiro Ministério</button></div>
            <?php else: ?>
            <div class="table-wrap">
                <table><thead><tr><th>Ministério</th><th>Descrição</th><th>Membros</th><th>Acções</th></tr></thead><tbody>
                <?php foreach ($ministries['types'] as $t):
                    $count = count(array_filter($ministries['assignments'], fn($a) => $a['ministry_id']===$t['id'])); ?>
                <tr>
                    <td><strong>✝️ <?= sanitize($t['name']) ?></strong></td>
                    <td class="text-sm text-muted"><?= sanitize($t['description'] ?? '—') ?></td>
                    <td><span class="badge badge-success"><?= $count ?></span></td>
                    <td>
                        <form method="POST" onsubmit="return confirm('Remover ministério e todos os vínculos?')" style="display:inline">
                            <input type="hidden" name="action" value="delete_type">
                            <input type="hidden" name="type_id" value="<?= $t['id'] ?>">
                            <button type="submit" class="btn btn-danger btn-sm">🗑️</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
            <?php endif; ?>
        </div>

        <!-- Vínculos -->
        <div class="card">
            <div class="card-header"><h3 class="card-title">Membros Consagrados</h3><span class="badge badge-gold"><?= count($ministries['assignments']) ?></span></div>
            <?php if (empty($ministries['assignments'])): ?>
            <div class="empty-state"><div class="empty-icon">🙏</div><h3>Sem vínculos</h3><p>Vincule membros aos ministérios da igreja.</p></div>
            <?php else: ?>
            <div class="table-wrap">
                <table><thead><tr><th>Membro</th><th>Ministério</th><th>Subdivisão</th><th>Data de Consagração</th><th>Acções</th></tr></thead><tbody>
                <?php foreach ($ministries['assignments'] as $a):
                    $mname = getMemberName($churchId, $a['member_id']);
                    $mtype = '';
                    foreach ($ministries['types'] as $t) { if ($t['id']===$a['ministry_id']) { $mtype=$t['name']; break; } }
                ?>
                <tr>
                    <td><div class="member-info"><div class="member-avatar"><?= strtoupper(substr($mname,0,1)) ?></div><div style="font-weight:600"><?= sanitize($mname) ?></div></div></td>
                    <td><span class="badge badge-gold">✝️ <?= sanitize($mtype) ?></span></td>
                    <td class="text-sm text-muted"><?= sanitize(getSubdivisionName($churchId, $a['subdivision_id'] ?? null)) ?></td>
                    <td class="text-sm text-muted"><?= $a['date'] ? date('d/m/Y', strtotime($a['date'])) : '—' ?></td>
                    <td>
                        <form method="POST" onsubmit="return confirm('Remover vínculo?')" style="display:inline">
                            <input type="hidden" name="action" value="remove_assignment">
                            <input type="hidden" name="assignment_id" value="<?= $a['id'] ?>">
                            <button type="submit" class="btn btn-danger btn-sm">🗑️</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody></table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Criar Tipo -->
<div class="modal-overlay" id="modal-type">
    <div class="modal">
        <div class="modal-header"><h3 class="modal-title">Criar Ministério</h3><button class="modal-close">✕</button></div>
        <form method="POST">
            <input type="hidden" name="action" value="save_type">
            <input type="hidden" name="type_id" value="">
            <div class="modal-body">
                <div class="form-group"><label>Nome do Ministério <span style="color:var(--danger)">*</span></label><input type="text" name="type_name" class="form-control" required placeholder="ex: Bispo, Pastor, Presbítero, Diácono, Evangelista..."></div>
                <div class="form-group"><label>Descrição</label><textarea name="type_desc" class="form-control" rows="3" placeholder="Breve descrição do papel deste ministério..."></textarea></div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-outline modal-close">Cancelar</button><button type="submit" class="btn btn-primary">Criar Ministério</button></div>
        </form>
    </div>
</div>

<!-- Modal: Vincular -->
<div class="modal-overlay" id="modal-assign">
    <div class="modal">
        <div class="modal-header"><h3 class="modal-title">✝️ Vincular Membro ao Ministério</h3><button class="modal-close">✕</button></div>
        <form method="POST">
            <input type="hidden" name="action" value="assign">
            <div class="modal-body">
                <div class="form-group">
                    <label>Membro <span style="color:var(--danger)">*</span></label>
                    <select name="assign_member" class="form-control" required>
                        <option value="">— Seleccionar Membro —</option>
                        <?php foreach ($activeMembers as $m): ?>
                        <option value="<?= $m['id'] ?>"><?= sanitize($m['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Ministério <span style="color:var(--danger)">*</span></label>
                    <select name="assign_ministry" class="form-control" required>
                        <option value="">— Seleccionar Ministério —</option>
                        <?php foreach ($ministries['types'] as $t): ?>
                        <option value="<?= $t['id'] ?>"><?= sanitize($t['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Subdivisão</label>
                        <select name="assign_subdivision" class="form-control">
                            <option value="">— Geral —</option>
                            <?php foreach ($subsData['subdivisions'] as $s): ?>
                            <option value="<?= $s['id'] ?>"><?= sanitize($s['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Data de Consagração</label>
                        <input type="date" name="assign_date" class="form-control" value="<?= date('Y-m-d') ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-outline modal-close">Cancelar</button><button type="submit" class="btn btn-primary">Vincular</button></div>
        </form>
    </div>
</div>

<?php renderFooter(); ?>
<?php renderJS(); ?></body></html>
