<?php
define('DEPTH', 1);
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
$user = currentUser();
if (!$user || !in_array($user['role'], ['finance_user','admin'])) { header('Location: ../index.php'); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: ' . (isset($_POST['redirect_month']) ? 'index.php?month='.$_POST['redirect_month'] : 'index.php')); exit; }

$churchId = 'main';
$finance  = getFinance($churchId);

$action = $_POST['action'] ?? 'transaction';

if ($action === 'save_category') {
    $name = trim($_POST['cat_name'] ?? '');
    $type = $_POST['cat_type'] ?? 'entrada';
    if ($name) {
        $finance['categories'][] = ['id' => generateId('cat'), 'name' => $name, 'type' => $type];
        saveFinance($churchId, $finance);
        flashMessage('success', 'Categoria criada: ' . $name);
    }
    header('Location: categories.php'); exit;
}

// Registar transacção
$amount = (float)($_POST['amount'] ?? 0);
if ($amount > 0) {
    $finance['transactions'][] = [
        'id'          => generateId('txn'),
        'type'        => in_array($_POST['type'], ['entrada','saida']) ? $_POST['type'] : 'entrada',
        'category'    => trim($_POST['category'] ?? 'Outra'),
        'amount'      => $amount,
        'description' => trim($_POST['description'] ?? ''),
        'date'        => $_POST['date'] ?? date('Y-m-d'),
        'created_by'  => $user['name'],
        'created_at'  => date('Y-m-d H:i:s')
    ];
    saveFinance($churchId, $finance);
    flashMessage('success', 'Movimento registado com sucesso.');
}
header('Location: ' . (isset($_POST['redirect_month']) ? 'index.php?month='.$_POST['redirect_month'] : 'index.php')); exit;
