<?php
// ═══════════════════════════════════════════════════════════════
//  SIGEDEC STANDALONE — config.php
// ═══════════════════════════════════════════════════════════════
define('SIGEDEC_VERSION',   '1.0.0');
define('SIGEDEC_HOME',      'https://sigedec.asaf.fyi');
define('SIGEDEC_ACTIVATE',  'https://sigedec.asaf.fyi/api/activate.php');
define('SIGEDEC_VERIFY',    'https://sigedec.asaf.fyi/api/verify.php');
define('HMAC_SECRET',       'Sigdec@Asaf#2024$Mz_StandAlone_Key');
define('DATA_DIR',          __DIR__ . '/../data');
define('CHURCHES_DIR',      DATA_DIR . '/churches');
define('SYSTEM_FILE',       DATA_DIR . '/system.json');
define('LICENSE_FILE',      DATA_DIR . '/license.json');
define('CONTACT_EMAIL',     'audivido3@gmail.com');
define('SITE_NAME',         'SIGEDEC');

if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_strict_mode', 1);
    session_set_cookie_params(['samesite' => 'Strict']);
    session_start();
}

foreach ([DATA_DIR, CHURCHES_DIR] as $dir) {
    if (!is_dir($dir)) mkdir($dir, 0755, true);
}

require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/data.php';
require_once __DIR__ . '/lang.php';

// Inicializar sistema se necessário
if (!file_exists(SYSTEM_FILE)) {
    $system = [
        'admin' => [
            'email'      => 'admin@sigedec.local',
            'password'   => password_hash('Admin@2025!', PASSWORD_DEFAULT),
            'name'       => 'Administrador',
            'created_at' => date('Y-m-d H:i:s')
        ],
        'church' => [],
        'settings' => ['app_name' => 'SIGEDEC Standalone', 'version' => SIGEDEC_VERSION]
    ];
    file_put_contents(SYSTEM_FILE, json_encode($system, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function isActivated(): bool {
    if (!file_exists(LICENSE_FILE)) return false;
    $lic = json_decode(file_get_contents(LICENSE_FILE), true);
    if (empty($lic['activated']) || empty($lic['domain']) || empty($lic['token'])) return false;
    // Verificar domínio
    $host = $_SERVER['HTTP_HOST'] ?? '';
    if ($host !== $lic['domain']) return false;
    // Verificar assinatura HMAC
    $expected = hash_hmac('sha256', $lic['domain'] . '|' . $lic['activated_at'], HMAC_SECRET);
    return hash_equals($expected, $lic['token']);
}
