<?php
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'member') { header('Location: /index.php'); exit; }

$churchId = $user['church_id'];
$memberId = $user['member_id'];
$church   = getChurchInfo($churchId);
$lang     = getLang();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $currentPass = $_POST['current_password'] ?? '';
    $newPass     = $_POST['new_password'] ?? '';
    $confirmPass = $_POST['confirm_password'] ?? '';

    $member = getMemberById($churchId, $memberId);

    if (!$member || !password_verify($currentPass, $member['portal_password'] ?? '')) {
        flashMessage('danger', $lang === 'en' ? 'Current password is incorrect.' : 'A senha actual está incorrecta.');
    } elseif (strlen($newPass) < 6) {
        flashMessage('danger', $lang === 'en' ? 'New password must have at least 6 characters.' : 'A nova senha deve ter pelo menos 6 caracteres.');
    } elseif ($newPass !== $confirmPass) {
        flashMessage('danger', $lang === 'en' ? 'Passwords do not match.' : 'As senhas não coincidem.');
    } else {
        $member['portal_password'] = password_hash($newPass, PASSWORD_DEFAULT);
        saveMember($churchId, $member);
        flashMessage('success', $lang === 'en' ? 'Password changed successfully.' : 'Senha alterada com sucesso.');
    }
    header('Location: password.php');
    exit;
}

renderHead(($lang === 'en' ? 'Change Password' : 'Alterar Senha') . ' — ' . $church['name']);
?>
<body>
<?php renderSidebar('member', $church); ?>
<div class="main-content">
    <div class="topbar">
        <div class="topbar-left">
            <div class="topbar-title"><?= $lang === 'en' ? 'Change Password' : 'Alterar Senha' ?></div>
            <div class="topbar-sub"><?= sanitize($church['name']) ?></div>
        </div>
        <div class="topbar-actions">
            <a href="index.php" class="btn btn-outline btn-sm">← <?= $lang === 'en' ? 'Back' : 'Voltar' ?></a>
        </div>
    </div>
    <div class="page-content">
        <?php renderFlash(); ?>
        <div class="card" style="max-width:420px;margin:0 auto">
            <div class="card-header">
                <h3 class="card-title">🔐 <?= $lang === 'en' ? 'Change Password' : 'Alterar Senha' ?></h3>
            </div>
            <form method="POST" style="padding:1.5rem">
                <div class="form-group">
                    <label><?= $lang === 'en' ? 'Current Password' : 'Senha Actual' ?></label>
                    <div class="pass-wrap">
                        <input type="password" name="current_password" id="pass1" class="form-control" required placeholder="••••••••">
                        <button type="button" onclick="togglePassField('pass1')" class="pass-eye">👁</button>
                    </div>
                </div>
                <div class="form-group">
                    <label><?= $lang === 'en' ? 'New Password' : 'Nova Senha' ?></label>
                    <div class="pass-wrap">
                        <input type="password" name="new_password" id="pass2" class="form-control" required placeholder="••••••••" minlength="6">
                        <button type="button" onclick="togglePassField('pass2')" class="pass-eye">👁</button>
                    </div>
                </div>
                <div class="form-group">
                    <label><?= $lang === 'en' ? 'Confirm New Password' : 'Confirmar Nova Senha' ?></label>
                    <div class="pass-wrap">
                        <input type="password" name="confirm_password" id="pass3" class="form-control" required placeholder="••••••••" minlength="6">
                        <button type="button" onclick="togglePassField('pass3')" class="pass-eye">👁</button>
                    </div>
                </div>
                <p style="font-size:0.8rem;color:var(--text-muted);margin-bottom:1rem">
                    <?= $lang === 'en' ? 'Minimum 6 characters.' : 'Mínimo 6 caracteres.' ?>
                </p>
                <button type="submit" class="btn btn-primary btn-full">
                    🔐 <?= $lang === 'en' ? 'Change Password' : 'Alterar Senha' ?>
                </button>
            </form>
        </div>
    </div>
</div>
<?php renderJS(); ?>
<script>
function togglePassField(id) {
    const i = document.getElementById(id);
    i.type = i.type === 'password' ? 'text' : 'password';
}
</script>
</body>
</html>
