<?php
require_once __DIR__ . '/../includes/config.php';
if (!isActivated()) { header('Location: ../activate.php'); exit; }
require_once __DIR__ . '/../includes/layout.php';

$user = currentUser();
if (!$user || $user['role'] !== 'member') { header('Location: /index.php'); exit; }

$churchId = $user['church_id'];
$memberId = $user['member_id'];
$church   = getChurchInfo($churchId);
$lang     = getLang();

// Handle AJAX photo upload
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $base64 = trim($_POST['photo_data'] ?? '');
    if (!$base64) {
        flashMessage('danger', $lang === 'en' ? 'No image data received.' : 'Nenhum dado de imagem recebido.');
    } else {
        $result = saveMemberPhoto($churchId, $memberId, $base64);
        if ($result === true) {
            flashMessage('success', $lang === 'en' ? 'Photo updated successfully.' : 'Foto actualizada com sucesso.');
        } else {
            flashMessage('danger', is_string($result) ? $result : ($lang === 'en' ? 'Error saving photo.' : 'Erro ao guardar a foto.'));
        }
    }
    header('Location: photo.php');
    exit;
}

$photoUrl = getMemberPhotoUrl($churchId, $memberId);
renderHead(($lang === 'en' ? 'Change Photo' : 'Alterar Foto') . ' — ' . $church['name']);
?>
<body>
<?php renderSidebar('member', $church); ?>
<div class="main-content">
    <div class="topbar">
        <div class="topbar-left">
            <div class="topbar-title"><?= $lang === 'en' ? 'Change Photo' : 'Alterar Foto' ?></div>
            <div class="topbar-sub"><?= sanitize($church['name']) ?></div>
        </div>
        <div class="topbar-actions">
            <a href="index.php" class="btn btn-outline btn-sm">← <?= $lang === 'en' ? 'Back' : 'Voltar' ?></a>
        </div>
    </div>
    <div class="page-content">
        <?php renderFlash(); ?>

        <div class="card" style="max-width:480px;margin:0 auto">
            <div class="card-header">
                <h3 class="card-title">📷 <?= $lang === 'en' ? 'Profile Photo' : 'Foto de Perfil' ?></h3>
            </div>
            <div style="padding:1.5rem">
                <!-- Current photo preview -->
                <div style="text-align:center;margin-bottom:1.5rem">
                    <div id="photoPreview" style="width:140px;height:140px;border-radius:50%;margin:0 auto;border:3px solid var(--border);overflow:hidden;background:var(--bg-card);display:flex;align-items:center;justify-content:center">
                        <?php if ($photoUrl): ?>
                        <img src="<?= $photoUrl ?>" id="previewImg" alt="Foto" style="width:100%;height:100%;object-fit:cover">
                        <?php else: ?>
                        <span id="previewPlaceholder" style="font-size:3rem;color:var(--text-muted)">👤</span>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if (!$photoUrl): ?>
                <div class="alert alert-info">
                    📷 <?= $lang === 'en'
                        ? 'You don\'t have a profile photo yet. Take a photo with your camera or pick one from your gallery. Maximum size: 2 MB.'
                        : 'Ainda não tem foto de perfil. Tire uma foto com a câmara ou escolha da galeria. Tamanho máximo: 2 MB.' ?>
                </div>
                <?php endif; ?>

                <!-- Upload form -->
                <form id="photoForm" method="POST">
                    <input type="hidden" name="photo_data" id="photoDataInput">

                    <!-- File input (gallery) -->
                    <input type="file" id="fileInput" accept="image/*" style="display:none" onchange="handleFileSelect(this)">
                    <!-- Camera input -->
                    <input type="file" id="cameraInput" accept="image/*" capture="environment" style="display:none" onchange="handleFileSelect(this)">

                    <div style="display:flex;flex-direction:column;gap:0.75rem">
                        <button type="button" class="btn btn-outline" onclick="document.getElementById('cameraInput').click()">
                            📷 <?= $lang === 'en' ? 'Take Photo (Camera)' : 'Tirar Foto (Câmara)' ?>
                        </button>
                        <button type="button" class="btn btn-outline" onclick="document.getElementById('fileInput').click()">
                            🖼️ <?= $lang === 'en' ? 'Choose from Gallery' : 'Escolher da Galeria' ?>
                        </button>
                        <button type="submit" id="saveBtn" class="btn btn-primary" style="display:none">
                            ✅ <?= $lang === 'en' ? 'Save Photo' : 'Guardar Foto' ?>
                        </button>
                    </div>

                    <p style="font-size:0.75rem;color:var(--text-muted);margin-top:0.75rem;text-align:center">
                        <?= $lang === 'en' ? 'Maximum size: 2 MB. Accepted formats: JPG, PNG, WEBP.' : 'Tamanho máximo: 2 MB. Formatos aceites: JPG, PNG, WEBP.' ?>
                    </p>
                </form>
            </div>
        </div>
    </div>
</div>
<?php renderJS(); ?>
<script>
function handleFileSelect(input) {
    const file = input.files[0];
    if (!file) return;

    // Check size
    if (file.size > 2 * 1024 * 1024) {
        alert('<?= $lang === 'en' ? 'Image exceeds the 2 MB limit. Please choose a smaller photo.' : 'A imagem ultrapassa os 2 MB. Por favor escolha uma foto menor.' ?>');
        input.value = '';
        return;
    }

    const reader = new FileReader();
    reader.onload = function(e) {
        const base64 = e.target.result;
        document.getElementById('photoDataInput').value = base64;

        // Show preview
        const previewDiv = document.getElementById('photoPreview');
        let img = document.getElementById('previewImg');
        if (!img) {
            previewDiv.innerHTML = '<img id="previewImg" alt="Foto" style="width:100%;height:100%;object-fit:cover">';
            img = document.getElementById('previewImg');
        }
        img.src = base64;
        document.getElementById('saveBtn').style.display = 'block';
    };
    reader.readAsDataURL(file);
}
</script>
</body>
</html>
